/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.tile;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import morph.avaritia.block.MachineBlock;
import morph.avaritia.util.TimeTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class MachineTileBase
extends BlockEntity {
    private boolean isActive;
    private boolean wasActive;
    private final TimeTracker offTracker = new TimeTracker();
    private boolean updateClient;
    public boolean fullContainerSync;

    public MachineTileBase(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public final void updateServer() {
        if (this.canWork()) {
            if (!this.isActive && !this.wasActive) {
                this.updateClient = true;
            }
            this.isActive = true;
            this.wasActive = false;
            this.doWork();
        } else {
            if (this.isActive) {
                this.onWorkStopped();
                this.wasActive = true;
                if (this.f_58857_ != null) {
                    this.offTracker.markTime(this.f_58857_);
                }
            }
            this.isActive = false;
        }
        this.updateCheck();
    }

    private void updateCheck() {
        if (this.wasActive && this.offTracker.hasDelayPassed(this.f_58857_, 100)) {
            this.wasActive = false;
            this.updateClient = true;
        }
        if (this.updateClient) {
            this.updateClient = false;
            BlockState state = this.f_58857_.m_8055_(this.m_58899_());
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)MachineBlock.ACTIVE, (Comparable)Boolean.valueOf(this.isActive)), 3);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("active", this.isActive);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.isActive = tag.m_128471_("active");
    }

    public abstract void writeGuiData(MCDataOutput var1, boolean var2);

    public abstract void readGuiData(MCDataInput var1, boolean var2);

    protected abstract boolean canWork();

    protected abstract void doWork();

    protected abstract void onWorkStopped();
}

